/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkParticipantHistory;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrenceHistory;
import filenet.vw.toolkit.runtime.VWTrkWork;
import filenet.vw.toolkit.runtime.summary.images.VWImageLoader;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerStatus;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import filenet.vw.toolkit.utils.uicontrols.security.VWParticipantLabel;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWSummaryInfoTableModel
extends AbstractTableModel
implements IVWPropertyChangeListener {
    private static final boolean DISPLAY_REMINDER_OVERDUE = false;
    public static final int SUMMARY_INFO_STEP = 1;
    public static final int SUMMARY_INFO_PARTICIPANT = 2;
    public static final int HISTORY_TABLE_MAP_COL = 0;
    public static final int HISTORY_TABLE_STEP_COL = 1;
    public static final int HISTORY_TABLE_OCCURRENCE_COL = 2;
    public static final int HISTORY_TABLE_PARTICIPANT_COL = 3;
    public static final int HISTORY_TABLE_RECEIVED_COL = 4;
    public static final int HISTORY_TABLE_STATUS_COL = 5;
    public static final int HISTORY_TABLE_RESPONSE_COL = 6;
    public static final int HISTORY_TABLE_COMMENTS_COL = 7;
    protected VWTrkDataModel m_trackerDataModel = null;
    private int m_mapId = -1;
    private boolean m_bAllMaps = false;
    private Vector m_columnNames = new Vector();
    private Vector m_selected = null;
    private int m_rowCount = -1;
    private Vector m_history = null;
    private int m_type = 1;
    VWTableSorter m_sorter = null;

    public VWSummaryInfoTableModel(VWTrkDataModel trackerDataModel, int mapId, int type) {
        this.createTableSorter();
        this.m_trackerDataModel = trackerDataModel;
        this.m_mapId = mapId;
        this.m_bAllMaps = this.m_mapId == -1;
        this.initColumnNames();
        this.setType(type);
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
    }

    public VWSummaryInfoTableModel(Vector selected) {
        this.createTableSorter();
        this.initColumnNames();
        this.setType(2);
        this.setSelected(selected);
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
        this.m_bAllMaps = false;
    }

    VWTrkDataModel getDataModel() {
        if (this.m_trackerDataModel == null && this.m_selected != null && this.m_selected.size() > 0) {
            for (int i = 0; i < this.m_selected.size(); ++i) {
                Object obj = this.m_selected.elementAt(i);
                if (obj instanceof VWTrkStep) {
                    VWTrkStep step = (VWTrkStep)obj;
                    this.m_trackerDataModel = step.getDataModel();
                    continue;
                }
                if (!(obj instanceof VWTrkStepOccurrence)) continue;
                VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)obj;
                this.m_trackerDataModel = occurrence.getDataModel();
            }
        }
        return this.m_trackerDataModel;
    }

    private void createTableSorter() {
        this.m_sorter = new VWTableSorter(this){

            public void tableChanged(TableModelEvent e) {
                int col = e.getColumn();
                if (e.getType() == 0 && col != 4 && col != -1) {
                    this.fireTableChanged(e);
                } else {
                    super.tableChanged(e);
                    this.sortByColumn(4);
                    int rowCount = super.getRowCount();
                    for (int i = 0; i < rowCount && i < VWSummaryInfoTableModel.this.m_history.size(); ++i) {
                        VWStepOccurrenceHistory stepOccurrenceHistory;
                        VWTrkStepOccurrenceHistory trkStepOccurrenceHistory;
                        VWTrkStepOccurrence trkStepOccurrence;
                        int stepId;
                        int instructionSheetId;
                        StepHistory historyAtRow = null;
                        OccurrenceHistory occurrenceHistoryAtRow = null;
                        if (VWSummaryInfoTableModel.this.m_history.elementAt(i) instanceof StepHistory) {
                            VWStepOccurrenceHistory stepOccurrenceHistory2;
                            VWTrkStepOccurrenceHistory trkStepOccurrenceHistory2;
                            historyAtRow = (StepHistory)VWSummaryInfoTableModel.this.m_history.elementAt(i);
                            if (historyAtRow == null || (trkStepOccurrenceHistory2 = historyAtRow.getHistory()) == null || (stepOccurrenceHistory2 = trkStepOccurrenceHistory2.getVWStepOccurrenceHistory()) == null) continue;
                            instructionSheetId = stepOccurrenceHistory2.getInstructionSheetId();
                            stepId = stepOccurrenceHistory2.getStepId();
                            if (instructionSheetId != -2 || stepId != 0 || i == 0) continue;
                            VWSummaryInfoTableModel.this.m_history.removeElementAt(i);
                            VWSummaryInfoTableModel.this.m_history.add(0, historyAtRow);
                            this.fireTableDataChanged();
                            break;
                        }
                        if (!(VWSummaryInfoTableModel.this.m_history.elementAt(i) instanceof OccurrenceHistory) || (occurrenceHistoryAtRow = (OccurrenceHistory)VWSummaryInfoTableModel.this.m_history.elementAt(i)) == null || (trkStepOccurrence = occurrenceHistoryAtRow.getOccurrence()) == null || (trkStepOccurrenceHistory = trkStepOccurrence.getStepOccurrenceHistory()) == null || (stepOccurrenceHistory = trkStepOccurrenceHistory.getVWStepOccurrenceHistory()) == null) continue;
                        instructionSheetId = stepOccurrenceHistory.getInstructionSheetId();
                        stepId = stepOccurrenceHistory.getStepId();
                        if (instructionSheetId != -2 || stepId != 0 || i == 0) continue;
                        VWSummaryInfoTableModel.this.m_history.removeElementAt(i);
                        VWSummaryInfoTableModel.this.m_history.add(0, occurrenceHistoryAtRow);
                        this.fireTableDataChanged();
                        break;
                    }
                }
            }
        };
    }

    public void setType(int type) {
        this.m_type = type;
        if (type == 1 && this.m_trackerDataModel != null) {
            this.selectAllSteps();
        } else {
            this.initData();
        }
    }

    public int getType() {
        return this.m_type;
    }

    public int getMapId(int row) {
        if (this.m_bAllMaps) {
            Indices indices = new Indices();
            if (!indices.rowToIndex(row)) {
                return -1;
            }
            if (this.m_type == 1) {
                StepHistory history = (StepHistory)this.m_history.elementAt(row);
                return history.getOccurrence().getStep().getMapId();
            }
            OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
            ParticipantHistory participantHistory = occurrenceHistory.getParticipant(indices.getParticipantIndex());
            VWTrkParticipant participant = participantHistory.getParticipant();
            return participant.getStep().getMapId();
        }
        return this.m_mapId;
    }

    public VWTrkMap getMap(int row) {
        int mapId = -1;
        mapId = this.m_bAllMaps ? this.getMapId(row) : this.m_mapId;
        return this.m_trackerDataModel.getMap(mapId);
    }

    public String getMapName(int row) {
        VWTrkMap map = this.getMap(row);
        if (map != null) {
            return map.getMapName();
        }
        return null;
    }

    boolean isAllMaps() {
        return this.m_bAllMaps;
    }

    private boolean isSameSelection(Vector selected) {
        if (selected == null && this.m_selected == null) {
            return true;
        }
        if (selected == null || this.m_selected == null) {
            return false;
        }
        if (selected.size() != this.m_selected.size()) {
            return false;
        }
        Vector temp = (Vector)selected.clone();
        for (int i = 0; i < this.m_selected.size(); ++i) {
            Object obj = this.m_selected.elementAt(i);
            if (!temp.contains(obj)) {
                return false;
            }
            temp.removeElement(obj);
        }
        return true;
    }

    void selectAllSteps() {
        if (this.m_trackerDataModel == null) {
            return;
        }
        Vector selected = null;
        selected = this.m_bAllMaps ? this.m_trackerDataModel.getStepCollection() : this.m_trackerDataModel.getStepCollection(this.m_mapId);
        if (!this.isSameSelection(selected)) {
            this.m_selected = selected;
            this.initData();
        }
    }

    public void setSelected(Vector selection) {
        Object obj = null;
        Vector<VWTrkStep> selected = new Vector<VWTrkStep>();
        for (int i = 0; i < selection.size(); ++i) {
            obj = selection.elementAt(i);
            if (obj == null) continue;
            if (obj instanceof VWTrkStepOccurrence) {
                selected.addElement((VWTrkStep)obj);
                if (this.m_trackerDataModel != null) continue;
                this.m_trackerDataModel = ((VWTrkStepOccurrence)obj).getDataModel();
                continue;
            }
            if (!(obj instanceof VWTrkStep)) continue;
            VWTrkStep step = (VWTrkStep)obj;
            selected.addElement(step);
            if (this.m_trackerDataModel != null) continue;
            this.m_trackerDataModel = step.getDataModel();
        }
        if (!this.isSameSelection(selected)) {
            this.m_selected = selected;
            this.m_mapId = -1;
            if (this.m_trackerDataModel == null) {
                this.m_trackerDataModel = this.getDataModel();
            }
            if (this.m_trackerDataModel != null) {
                this.m_mapId = this.m_trackerDataModel.getSelectedMap().getMapId();
            }
            this.initData();
        }
    }

    void initData() {
        int i;
        if (this.m_selected == null) {
            return;
        }
        boolean bNeedUpdateThread = false;
        VWTrkStepOccurrence occurrence = null;
        if (this.m_history != null) {
            for (i = 0; i < this.m_history.size(); ++i) {
                Object obj = this.m_history.elementAt(i);
                if (obj == null || !(obj instanceof History)) continue;
                ((History)obj).removeReferences();
            }
            this.m_history.removeAllElements();
            this.m_history = null;
        }
        this.m_history = new Vector();
        if (this.m_selected != null) {
            for (i = 0; i < this.m_selected.size(); ++i) {
                Vector occurrences;
                Object selected = this.m_selected.elementAt(i);
                VWTrkStep step = null;
                if (selected == null) continue;
                if (selected instanceof VWTrkStepOccurrence) {
                    occurrence = (VWTrkStepOccurrence)selected;
                    if (occurrence == null) continue;
                    String stepName = "";
                    if (this.m_trackerDataModel == null) {
                        this.m_trackerDataModel = occurrence.getDataModel();
                    }
                    if (this.m_trackerDataModel != null && (step = this.m_trackerDataModel.findStep(occurrence.getStep().getMapId(), occurrence.getStepId())) != null) {
                        stepName = step.getStepName();
                    }
                    this.m_history.addElement(new OccurrenceHistory(stepName, occurrence));
                    if (bNeedUpdateThread || occurrence.getCompletionDate() != null) continue;
                    bNeedUpdateThread = true;
                    continue;
                }
                if (!(selected instanceof VWTrkStep) || (step = (VWTrkStep)selected) == null || (occurrences = step.getOccurrenceCollection()) == null) continue;
                for (int j = 0; j < occurrences.size(); ++j) {
                    Object obj = occurrences.elementAt(j);
                    if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                    occurrence = (VWTrkStepOccurrence)obj;
                    if (!bNeedUpdateThread && occurrence.getCompletionDate() == null) {
                        bNeedUpdateThread = true;
                    }
                    if (this.m_type == 1) {
                        this.m_history.addElement(new StepHistory(step.getStepName(), occurrence));
                        continue;
                    }
                    this.m_history.addElement(new OccurrenceHistory(step.getStepName(), occurrence));
                }
            }
        }
        this.m_rowCount = -1;
        this.m_rowCount = this.getRowCount();
        this.fireTableDataChanged();
    }

    public Object getValueAt(int row, int col) {
        if (this.m_history == null) {
            return null;
        }
        if (row >= this.getRowCount()) {
            return null;
        }
        if (this.m_type == 1) {
            StepHistory history = null;
            VWTrkStepOccurrenceHistory stepOccurrenceHistory = null;
            VWTrkStepOccurrence occurrence = null;
            if (this.m_history != null && (history = (StepHistory)this.m_history.elementAt(row)) != null) {
                stepOccurrenceHistory = history.getHistory();
                occurrence = history.getOccurrence();
            }
            switch (col) {
                case 0: {
                    return this.getMapName(row);
                }
                case 1: {
                    ImageIcon icon = null;
                    icon = occurrence != null ? occurrence.getLockedStatusIcon() : VWImageLoader.createImageIcon("blank.gif");
                    return new JLabel(history.getStepName(), icon, 2);
                }
                case 2: {
                    return new Integer(history.getOccurrenceIndex());
                }
                case 4: {
                    if (stepOccurrenceHistory == null) {
                        return null;
                    }
                    return stepOccurrenceHistory.getDateReceived();
                }
                case 5: {
                    if (occurrence == null) {
                        return null;
                    }
                    return new VWTrackerStatus(occurrence.getStatus(), stepOccurrenceHistory.getCompletionDate());
                }
            }
            return null;
        }
        Indices indices = new Indices();
        if (indices != null && !indices.rowToIndex(row)) {
            return null;
        }
        OccurrenceHistory occurrenceHistory = null;
        ParticipantHistory privateParticipantHistory = null;
        VWTrkParticipantHistory participantHistory = null;
        VWTrkParticipant participant = null;
        if (this.m_history != null && (occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex())) != null && (privateParticipantHistory = occurrenceHistory.getParticipant(indices.getParticipantIndex())) != null) {
            participantHistory = privateParticipantHistory.getHistory();
            participant = privateParticipantHistory.getParticipant();
        }
        int statusIndex = indices.getStatusIndex();
        if (occurrenceHistory == null && participantHistory == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return this.getMapName(row);
            }
            case 1: {
                if (statusIndex > 0) {
                    return null;
                }
                if (!privateParticipantHistory.isFirstOfWork()) {
                    return null;
                }
                return new JLabel(occurrenceHistory.getStepName(), null, 2);
            }
            case 2: {
                if (statusIndex > 0) {
                    return null;
                }
                if (!privateParticipantHistory.isFirstOfWork()) {
                    return null;
                }
                return new Integer(occurrenceHistory.getOccurrenceIndex());
            }
            case 3: {
                if (statusIndex > 0) {
                    return null;
                }
                if (participantHistory == null) {
                    return null;
                }
                return this.getParticipantName(participant, participantHistory);
            }
            case 4: {
                if (statusIndex > 0) {
                    return null;
                }
                if (participantHistory == null) {
                    return null;
                }
                return participantHistory.getDateReceived();
            }
            case 5: {
                return privateParticipantHistory.getStatus(statusIndex);
            }
            case 6: {
                if (participantHistory == null) {
                    return null;
                }
                if (statusIndex == privateParticipantHistory.getCount() - 1) {
                    return participantHistory.getResponse();
                }
                return null;
            }
            case 7: {
                if (participantHistory == null) {
                    return null;
                }
                if (statusIndex == privateParticipantHistory.getCount() - 1) {
                    return participantHistory.getComments();
                }
                return null;
            }
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement(VWResource.s_map);
        this.m_columnNames.addElement(VWResource.s_step);
        this.m_columnNames.addElement("");
        this.m_columnNames.addElement(VWResource.s_participant);
        this.m_columnNames.addElement(VWResource.s_received);
        this.m_columnNames.addElement(VWResource.s_status);
        this.m_columnNames.addElement(VWResource.s_response);
        this.m_columnNames.addElement(VWResource.s_comments);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 4: {
                return Date.class;
            }
            case 2: {
                return Integer.class;
            }
            case 5: {
                return VWTrackerStatus.class;
            }
            case 1: 
            case 3: {
                return JLabel.class;
            }
            case 6: 
            case 7: {
                return String.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        if (this.m_rowCount != -1) {
            return this.m_rowCount;
        }
        if (this.m_history == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.m_history.size(); ++i) {
            count += ((History)this.m_history.elementAt(i)).getCount();
        }
        return count;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        if (event == null || this.m_history == null || this.m_history.size() == 0) {
            return;
        }
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            Vector items = null;
            int type = event.getID();
            block0 : switch (type) {
                case 701: {
                    items = source.getItemsChanged();
                    if (items == null || items.size() == 0) {
                        return;
                    }
                    int stepId = -1;
                    int col = this.m_type == 1 ? 1 : 3;
                    for (int i = 0; i < items.size(); ++i) {
                        int row = 0;
                        obj = items.elementAt(i);
                        if (obj instanceof VWTrkStep) {
                            stepId = ((VWTrkStep)obj).getStepId();
                        } else if (obj instanceof VWTrkStepOccurrence) {
                            stepId = ((VWTrkStepOccurrence)obj).getStepId();
                        }
                        for (int j = 0; j < this.m_history.size(); ++j) {
                            if (!(this.m_history.elementAt(j) instanceof History)) continue;
                            History history = (History)this.m_history.elementAt(j);
                            int count = history.getCount();
                            if (history.getStepId() == stepId) {
                                for (int k = 0; k < count; ++k) {
                                    this.fireTableCellUpdated(row + k, col);
                                }
                            }
                            row += count;
                        }
                    }
                    break;
                }
                case 704: {
                    items = source.getItemsChanged();
                    if (items == null || items.size() == 0) {
                        return;
                    }
                    block8: for (int i = 0; i < items.size(); ++i) {
                        obj = items.elementAt(i);
                        if (obj == null || !(obj instanceof VWTrkStep)) continue;
                        VWTrkStep step = (VWTrkStep)obj;
                        if (this.m_selected.contains(step)) {
                            this.initData();
                            break block0;
                        }
                        for (int j = 0; j < this.m_selected.size(); ++j) {
                            obj = this.m_selected.elementAt(j);
                            if (!(obj instanceof VWTrkStepOccurrence) || step != ((VWTrkStepOccurrence)obj).getStep()) continue;
                            this.initData();
                            continue block8;
                        }
                    }
                    break;
                }
                case 705: {
                    this.initData();
                }
            }
        }
    }

    boolean isLockable(int row) {
        return this.isLockedStatus(row, 1);
    }

    boolean isUnockable(int row) {
        return this.isLockedStatus(row, 2);
    }

    boolean isLockedStatus(int row, int lockedStatus) {
        if (row < 0 || row >= this.getRowCount()) {
            return false;
        }
        if (this.m_type == 1) {
            StepHistory history = (StepHistory)this.m_history.elementAt(row);
            VWTrkStepOccurrence occurrence = history.getOccurrence();
            if ((occurrence.getLockedStatus() & lockedStatus) != 0) {
                return true;
            }
        } else if (this.m_type == 2) {
            Indices indices = new Indices();
            if (!indices.rowToIndex(row)) {
                return false;
            }
            OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
            VWTrkParticipant participant = null;
            if (occurrenceHistory != null) {
                participant = occurrenceHistory.getParticipant(indices.getParticipantIndex()).getParticipant();
            }
            if (participant != null && participant.getLockedStatus() == lockedStatus) {
                return true;
            }
        }
        return false;
    }

    Object getItem(int row) {
        if (this.m_type == 1) {
            StepHistory history = (StepHistory)this.m_history.elementAt(row);
            VWTrkStepOccurrence occurrence = history.getOccurrence();
            return occurrence;
        }
        if (this.m_type == 2) {
            Indices indices = new Indices();
            if (!indices.rowToIndex(row)) {
                return null;
            }
            OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
            if (occurrenceHistory != null) {
                return occurrenceHistory.getParticipant(indices.getParticipantIndex()).getParticipant();
            }
        }
        return null;
    }

    public VWTableSorter getTableSorter() {
        return this.m_sorter;
    }

    VWTrkStep getStep(int row) {
        VWTrkStepOccurrence occurrence = this.getStepOccurrence(row);
        if (occurrence != null) {
            return occurrence.getStep();
        }
        return null;
    }

    VWTrkStepOccurrence getStepOccurrence(int row) {
        Indices indices = new Indices();
        if (!indices.rowToIndex(row)) {
            return null;
        }
        if (this.m_type == 1) {
            StepHistory history = (StepHistory)this.m_history.elementAt(row);
            if (history != null) {
                return history.getOccurrence();
            }
        } else {
            OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
            if (occurrenceHistory != null) {
                return occurrenceHistory.getOccurrence();
            }
        }
        return null;
    }

    JLabel getStepName(int row) {
        Indices indices = new Indices();
        JLabel stepName = new JLabel();
        if (!indices.rowToIndex(row)) {
            return null;
        }
        if (this.m_type == 1) {
            StepHistory history = (StepHistory)this.m_history.elementAt(row);
            if (history != null) {
                stepName.setText(history.getStepName());
                VWTrkStepOccurrence occurrence = history.getOccurrence();
                if (occurrence != null) {
                    stepName.setIcon(occurrence.getLockedStatusIcon());
                }
            }
        } else {
            OccurrenceHistory occurrenceHistory;
            Object obj = this.m_history.elementAt(indices.getOccurrenceIndex());
            if (obj != null && obj instanceof OccurrenceHistory && (occurrenceHistory = (OccurrenceHistory)obj) != null) {
                stepName.setText(occurrenceHistory.getStepName());
            }
        }
        return stepName;
    }

    Integer getOccurrence(int row) {
        Indices indices = new Indices();
        if (!indices.rowToIndex(row)) {
            return null;
        }
        if (this.m_type == 1) {
            StepHistory history = (StepHistory)this.m_history.elementAt(row);
            return new Integer(history.getOccurrenceIndex());
        }
        OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
        if (occurrenceHistory != null) {
            return new Integer(occurrenceHistory.getOccurrenceIndex());
        }
        return null;
    }

    protected JLabel getParticipantName(int row) {
        if (this.m_type == 1) {
            return null;
        }
        Indices indices = new Indices();
        if (!indices.rowToIndex(row)) {
            return null;
        }
        OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
        if (occurrenceHistory == null) {
            return null;
        }
        ParticipantHistory privateParticipantHistory = occurrenceHistory.getParticipant(indices.getParticipantIndex());
        if (privateParticipantHistory == null) {
            return null;
        }
        VWTrkParticipantHistory participantHistory = privateParticipantHistory.getHistory();
        if (participantHistory == null) {
            return null;
        }
        VWTrkParticipant participant = privateParticipantHistory.getParticipant();
        if (participant == null) {
            return null;
        }
        return this.getParticipantName(participant, participantHistory);
    }

    private JLabel getParticipantName(VWTrkParticipant participant, VWTrkParticipantHistory participantHistory) {
        VWParticipantItem pItem = new VWParticipantItem(participant.getParticipant());
        String queueName = null;
        String name = pItem.getDisplayName();
        JLabel label = null;
        if (name == null) {
            queueName = participant.getQueueName();
        } else {
            ImageIcon icon = null;
            if (participant.getLockedStatus() != 0) {
                icon = participant.getLockedStatusIcon();
            }
            label = new VWParticipantLabel(name, icon);
        }
        VWParticipant user = null;
        if (participant.isActive()) {
            user = participant.getLockedUser();
        } else if (participantHistory != null) {
            user = participantHistory.getUser();
        }
        if (user != null && user.getParticipantName() != null && user.getParticipantName().length() > 0) {
            VWParticipantItem pUser = new VWParticipantItem(user);
            if (name != null) {
                if (VWStringUtils.compare(pItem.getShortName(), pUser.getShortName()) != 0) {
                    name = name + "(" + pUser.getDisplayName() + ")";
                }
            } else {
                name = queueName != null ? "[" + queueName + "]" + pUser.getDisplayName() : "";
            }
        } else if (name == null) {
            name = queueName == null ? VWResource.s_noneParticipant : "[" + queueName + "]";
        }
        if (label == null) {
            label = new JLabel(name, null, 2);
        } else if (VWStringUtils.compare(label.getText(), name) != 0) {
            label.setText(name);
        }
        return label;
    }

    protected JLabel getOperationName(int row) {
        Indices indices = new Indices();
        if (!indices.rowToIndex(row)) {
            return null;
        }
        if (this.m_type == 1) {
            StepHistory history = (StepHistory)this.m_history.elementAt(row);
            if (history == null) {
                return null;
            }
            VWTrkStepOccurrence occurrence = history.getOccurrence();
            if (occurrence == null) {
                return null;
            }
            String opName = occurrence.getOperationName();
            if (opName != null) {
                return new JLabel(opName, null, 2);
            }
            return null;
        }
        OccurrenceHistory occurrenceHistory = (OccurrenceHistory)this.m_history.elementAt(indices.getOccurrenceIndex());
        if (occurrenceHistory == null) {
            return null;
        }
        ParticipantHistory privateParticipantHistory = occurrenceHistory.getParticipant(indices.getParticipantIndex());
        if (privateParticipantHistory == null) {
            return null;
        }
        VWTrkParticipantHistory participantHistory = privateParticipantHistory.getHistory();
        if (participantHistory == null) {
            return null;
        }
        VWTrkParticipant participant = privateParticipantHistory.getParticipant();
        if (participant == null) {
            return null;
        }
        return this.getOperationName(participant);
    }

    private JLabel getOperationName(VWTrkParticipant participant) {
        String queueName = null;
        String operationName = null;
        JLabel label = null;
        try {
            queueName = participant.getQueueName();
            if (queueName == null) {
                return null;
            }
            if (this.getDataModel().getProcess().getSession().getQueue(queueName).getIsConnectorQueue()) {
                operationName = participant.getOperationName();
            }
        }
        catch (Exception ex) {
            operationName = null;
            VWDebug.logException(ex);
        }
        if (operationName != null) {
            label = new JLabel(operationName, null, 2);
        }
        return label;
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
            this.m_columnNames = null;
        }
        if (this.m_selected != null) {
            this.m_selected.removeAllElements();
            this.m_selected = null;
        }
        if (this.m_history != null) {
            for (int i = 0; i < this.m_history.size(); ++i) {
                Object obj = this.m_history.elementAt(i);
                if (obj == null || !(obj instanceof History)) continue;
                ((History)obj).removeReferences();
            }
            this.m_history.removeAllElements();
            this.m_history = null;
        }
        this.m_sorter = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }

    private class Indices {
        int m_occurrenceIndex = -1;
        int m_participantIndex = -1;
        int m_statusIndex = -1;
        int m_row;

        private Indices() {
        }

        boolean rowToIndex(int row) {
            this.m_row = row;
            if (VWSummaryInfoTableModel.this.m_type == 1) {
                this.m_occurrenceIndex = row;
                this.m_participantIndex = -1;
                return true;
            }
            if (VWSummaryInfoTableModel.this.m_type == 2) {
                int count = 0;
                OccurrenceHistory occurrenceHistory = null;
                ParticipantHistory participantHistory = null;
                for (int i = 0; i < VWSummaryInfoTableModel.this.m_history.size(); ++i) {
                    occurrenceHistory = (OccurrenceHistory)VWSummaryInfoTableModel.this.m_history.elementAt(i);
                    if (occurrenceHistory == null) continue;
                    Vector participants = occurrenceHistory.getParticipants();
                    for (int j = 0; j < participants.size(); ++j) {
                        participantHistory = (ParticipantHistory)participants.elementAt(j);
                        if (row >= (count += participantHistory.getCount())) continue;
                        this.m_occurrenceIndex = i;
                        this.m_participantIndex = j;
                        this.m_statusIndex = row - count + participantHistory.getCount();
                        return true;
                    }
                }
            }
            this.m_occurrenceIndex = -1;
            this.m_participantIndex = -1;
            return false;
        }

        int getOccurrenceIndex() {
            return this.m_occurrenceIndex;
        }

        int getParticipantIndex() {
            return this.m_participantIndex;
        }

        int getStatusIndex() {
            return this.m_statusIndex;
        }

        int getRow() {
            return this.m_row;
        }
    }

    private static class ParticipantHistory {
        VWTrkParticipant m_participant = null;
        VWTrkParticipantHistory m_participantHistory = null;
        int m_statusCount = 0;
        boolean m_bFirstParticipantOfWork = false;

        ParticipantHistory(VWTrkParticipant participant, boolean bFirstParticipant) {
            this.m_bFirstParticipantOfWork = bFirstParticipant;
            this.m_participant = participant;
            if (this.m_participant != null) {
                this.m_participantHistory = this.m_participant.getParticipantHistory();
            }
            this.m_statusCount = 1;
        }

        int getCount() {
            if (this.m_statusCount == 0 && this.m_participantHistory != null) {
                this.m_statusCount = !this.m_participant.isActive() ? 1 : 0;
                if (this.m_participantHistory.isReminded()) {
                    ++this.m_statusCount;
                }
                if (this.m_participantHistory.isOverdue()) {
                    ++this.m_statusCount;
                }
                if (this.m_statusCount == 0) {
                    this.m_statusCount = 1;
                }
            }
            return this.m_statusCount;
        }

        VWTrkParticipant getParticipant() {
            return this.m_participant;
        }

        VWTrkParticipantHistory getHistory() {
            return this.m_participantHistory;
        }

        VWTrackerStatus getStatus(int index) {
            return new VWTrackerStatus(this.m_participant.getStatus(), this.m_participantHistory.getCompletionDate());
        }

        boolean isFirstOfWork() {
            return this.m_bFirstParticipantOfWork;
        }

        void removeReferences() {
            this.m_participant = null;
            this.m_participantHistory = null;
        }
    }

    private class OccurrenceHistory
    extends History {
        Vector m_participants;
        int m_count;

        OccurrenceHistory(String stepName, VWTrkStepOccurrence occurrence) {
            super(stepName, occurrence);
            this.m_participants = new Vector();
            this.m_count = 0;
            Vector workCollection = occurrence.getWorkCollection();
            if (workCollection != null) {
                for (int i = 0; i < workCollection.size(); ++i) {
                    VWTrkWork work = (VWTrkWork)workCollection.elementAt(i);
                    Vector participants = work.getParticipants();
                    for (int j = 0; j < participants.size(); ++j) {
                        ParticipantHistory participant = new ParticipantHistory((VWTrkParticipant)participants.elementAt(j), j == 0);
                        this.m_participants.addElement(participant);
                        this.m_count += participant.getCount();
                    }
                }
            }
        }

        int getCount() {
            return this.m_count;
        }

        ParticipantHistory getParticipant(int i) {
            if (i < this.m_participants.size()) {
                return (ParticipantHistory)this.m_participants.elementAt(i);
            }
            return null;
        }

        Vector getParticipants() {
            return this.m_participants;
        }

        void removeReferences() {
            super.removeReferences();
            if (this.m_participants != null) {
                for (int i = 0; i < this.m_participants.size(); ++i) {
                    Object obj = this.m_participants.elementAt(i);
                    if (obj == null || !(obj instanceof ParticipantHistory)) continue;
                    ((ParticipantHistory)obj).removeReferences();
                }
                this.m_participants.removeAllElements();
                this.m_participants = null;
            }
        }
    }

    private class StepHistory
    extends History {
        StepHistory(String stepName, VWTrkStepOccurrence occurrence) {
            super(stepName, occurrence);
        }

        int getCount() {
            if (this.m_stepOccurrence != null) {
                return 1;
            }
            return 0;
        }

        VWTrkStepOccurrence getOccurrence() {
            return this.m_stepOccurrence;
        }

        VWTrkStepOccurrenceHistory getHistory() {
            return this.m_stepOccurrence.getStepOccurrenceHistory();
        }

        void removeReferences() {
            super.removeReferences();
        }
    }

    private abstract class History {
        String m_stepName = null;
        VWTrkStepOccurrence m_stepOccurrence;

        History(String stepName, VWTrkStepOccurrence occurrence) {
            this.m_stepName = stepName;
            this.m_stepOccurrence = occurrence;
        }

        String getStepName() {
            return this.m_stepName;
        }

        VWTrkStepOccurrence getOccurrence() {
            return this.m_stepOccurrence;
        }

        int getOccurrenceIndex() {
            return this.m_stepOccurrence.getOccurrenceIndex() + 1;
        }

        int getStepId() {
            return this.m_stepOccurrence.getStepId();
        }

        abstract int getCount();

        void removeReferences() {
            this.m_stepName = null;
            this.m_stepOccurrence = null;
        }
    }
}

